PaintCatalogueMenu = {}

function PaintCatalogueMenu.createItemMenu(player, context, items)
    local catalogueItem
    for _, item in ipairs(items) do
        if not instanceof(item, "InventoryItem") then
            item = item.items[1]
        end
        if item:getFullType():find("PaintYourRide.CataloguePaint") then
            catalogueItem = item
        end
    end

    -- Found catalogue, edit menu options
    if catalogueItem then
        local optionCheckMap = context:getOptionFromName(getText("ContextMenu_CheckMap"))
        if optionCheckMap then
            optionCheckMap.name = getText("ContextMenu_PaintYourRide_CatalogueView")
        end

        local optionRenameMap = context:getOptionFromName(getText("ContextMenu_RenameMap"))
        if optionRenameMap then
            optionRenameMap.name = getText("ContextMenu_PaintYourRide_CatalogueRename")
        end
    end
end

Events.OnFillInventoryObjectContextMenu.Add(PaintCatalogueMenu.createItemMenu)